local gc = Var("GameCommand")
local name = gc:GetName()

local focusColor   = color("1,1,1,1")
local unfocusColor = color("0.6,0.6,0.6,1")

local modeGraphics = {
	Regular = "_normal",
	Nonstop = "_nonstop",
	Oni = "_oni",
}

return Def.ActorFrame{
	Def.ActorFrame{
		Name="Base";
		LoadActor(THEME:GetPathG("_style","base"))..{
			InitCommand=cmd();
			GainFocusCommand=cmd(diffuse,focusColor);
			LoseFocusCommand=cmd(diffuse,unfocusColor);
			OffFocusedCommand=cmd(sleep,0.5;linear,0.25;addy,-SCREEN_HEIGHT);
			OffUnfocusedCommand=cmd(linear,0.2;zoomy,0);
		};

		LoadFont("_francophilsans Bold 24px")..{
			Text=THEME:GetString(Var "LoadingScreen",name.."Main");
			InitCommand=cmd(x,64;y,-24;);
			GainFocusCommand=cmd(diffuse,focusColor);
			LoseFocusCommand=cmd(diffuse,unfocusColor);
			OffFocusedCommand=cmd(sleep,0.5;linear,0.25;addy,-SCREEN_HEIGHT);
			OffUnfocusedCommand=cmd(linear,0.2;zoomy,0);
		};
		LoadFont("_francophilsans Bold 24px")..{
			Text=THEME:GetString(Var "LoadingScreen",name.."Secondary");
			InitCommand=cmd(x,62;y,10;valign,0;zoom,14/24;wrapwidthpixels,232);
			GainFocusCommand=cmd(diffuse,focusColor);
			LoseFocusCommand=cmd(diffuse,unfocusColor);
			OffFocusedCommand=cmd(sleep,0.5;linear,0.25;addy,-SCREEN_HEIGHT);
			OffUnfocusedCommand=cmd(linear,0.2;zoomy,0);
		};

		-- todo: argh
		Def.ActorFrame{
			Name="ModePreview";
			InitCommand=cmd(x,-64;);
			GainFocusCommand=function(self)
				if name == "Oni" then MESSAGEMAN:Broadcast("DangerOn")
				else MESSAGEMAN:Broadcast("DangerOff")
				end
			end;
			LoadActor(THEME:GetPathG("_gamemode","icons/"..modeGraphics[name]))..{
				Name="Icon";
				GainFocusCommand=cmd(diffuse,focusColor);
				LoseFocusCommand=cmd(diffuse,unfocusColor);
				OffFocusedCommand=cmd(sleep,0.5;linear,0.25;addy,-SCREEN_HEIGHT);
				OffUnfocusedCommand=cmd(linear,0.2;zoomy,0);
			};
		};
	};
};